/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ethernet;

import ibm.nways.ethernet.model.IfMauModel;
import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.util.Locale;

public class ActionEthernetIfMau
implements StatusMapper,
TableStatusNamer {
    private static String bundleName = "ibm.nways.ethernet.Resources";
    private static String enumBundle = "ibm.nways.ethernet.eui.EnumeratedResources";
    private boolean loggingOn = false;

    public ActionEthernetIfMau() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        try {
            Object[] objectArray = statusModelInfo.getIndexes();
            if (this.loggingOn) {
                System.out.println("ActionEthernetIfMau");
                System.out.println("Interface = " + objectArray[0] + " MAU = " + objectArray[1]);
                System.out.println("ifMauStatus = " + statusModelInfo.get("Panel.IfMauStatus"));
            }
            StatusAndExplain statusAndExplain = this.evaluateStatus((Integer)statusModelInfo.get("Panel.IfMauStatus"), objectArray);
            statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bundleName, "STATUS_NAME_IFMAU", objectArray);
        return i18NMsgFormat;
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        I18NString i18NString = new I18NString(bundleName, "STATUS_TABLE_NAME_IFMAU");
        return i18NString;
    }

    private StatusAndExplain evaluateStatus(int n, Object[] objectArray) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = objectArray[0];
        objectArray2[1] = objectArray[1];
        switch (n) {
            case 1: 
            case 2: 
            case 6: {
                statusAndExplain.statType = StatusType.UNKNOWN;
                objectArray2[2] = new I18NString(enumBundle, IfMauModel.Panel.IfMauStatusEnum.numericToSymbolic(n));
                break;
            }
            case 3: 
            case 4: {
                statusAndExplain.statType = StatusType.NORMAL;
                objectArray2[2] = new I18NString(enumBundle, IfMauModel.Panel.IfMauStatusEnum.numericToSymbolic(n));
                break;
            }
            case 5: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray2[2] = new I18NString(enumBundle, IfMauModel.Panel.IfMauStatusEnum.numericToSymbolic(n));
                break;
            }
            default: {
                statusAndExplain.statType = StatusType.UNKNOWN;
                objectArray2[2] = new I18NString(bundleName, "UNEXPECTED_IFMAU_STATUS");
            }
        }
        statusAndExplain.explain = new I18NGiblets(bundleName, "IF_MAU_STATUS_TEXT", objectArray2);
        if (this.loggingOn) {
            System.out.println("ret.statType = " + statusAndExplain.statType);
            System.out.println("ret.explain = " + statusAndExplain.explain.getTranslation(Locale.getDefault()));
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            ActionEthernetIfMau.this = ActionEthernetIfMau.this;
        }
    }
}

